<?php
    $fixedCryptoCoinContent = \App\Services\FrontendService::getFrontendContent(\App\Enums\Frontend\SectionKey::CRYPTO_COIN, \App\Enums\Frontend\Content::FIXED);
?>


<?php $__env->startSection('content'); ?>
    <main>
        <div class="form-section white img-adjust">
            <div class="linear-center"></div>
            <div class="container-fluid px-0">
                <div class="row justify-content-center align-items-center gy-5">
                    <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-8 col-sm-10 position-relative">
                        <div class="eth-icon">
                            <img src="<?php echo e(displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'first_crypto_coin'), "450X450")); ?>" alt="image">
                        </div>
                        <div class="bnb-icon">
                            <img src="<?php echo e(displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'second_crypto_coin'), "450X450")); ?>" alt="image">
                        </div>
                        <div class="ada-icon">
                            <img src="<?php echo e(displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'third_crypto_coin'), "450X450")); ?>" alt="image">
                        </div>
                        <div class="sol-icon">
                            <img src="<?php echo e(displayImage(getArrayValue($fixedCryptoCoinContent?->meta, 'fourth_crypto_coin'), "450X450")); ?>" alt="image">
                        </div>

                        <div class="form-wrapper">
                            <h4 class="form-title"><?php echo e(__(' Reset Your Password')); ?></h4>
                            <form method="POST" action="<?php echo e(route('password.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="token" value="<?php echo e($request->route('token')); ?>">

                                <div class="row g-3">
                                    <div class="col-12">
                                        <div class="form-inner">
                                            <label for="email"><?php echo e(__('Email')); ?></label>
                                            <input type="email" id="email" name="email" class="block" value="<?php echo e(old('email', $request->email)); ?>" autofocus placeholder="<?php echo e(__('Enter Email')); ?>" required>
                                        </div>

                                        <div class="form-inner">
                                            <label for="password"><?php echo e(__('Password')); ?></label>
                                            <input type="password" id="password" name="password" autocomplete="current-password" placeholder="<?php echo e(__('Enter Password')); ?>" required>
                                        </div>

                                        <div class="form-inner">
                                            <label for="password_confirmation"><?php echo e(__('Confirm Password')); ?></label>
                                            <input type="password" id="password_confirmation" name="password_confirmation" autocomplete="current-password" placeholder="<?php echo e(__('Enter your confirm password')); ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <button class="i-btn btn--lg btn--primary w-100" type="submit"><?php echo e(__('Reset Password')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dakehfsw/app.stellenccecapital.com/src/resources/views/auth/reset-password.blade.php ENDPATH**/ ?>