<?php $__env->startSection('content'); ?>
    <div class="main-content" data-simplebar>
        <div class="i-card-sm p-3 mb-4">
            <div class="row g-3">
                <div class="col-lg-4 col-md-6">
                    <div class="i-card-sm style-2 bg--dark shadow-none rounded-2">
                        <span class="text--light"><?php echo e(__('Primary Balance')); ?></span><span class="text-white fw-bold"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()->wallet->primary_balance)); ?></span>
                    </div>
                </div>
                <?php if(getArrayValue($setting->investment_setting, getInputName(\App\Enums\InvestmentType::INVESTMENT->name)) == \App\Enums\Status::ACTIVE->value): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="i-card-sm style-2 bg--dark shadow-none rounded-2">
                            <span class="text--light"><?php echo e(__('Investment Balance')); ?></span> <span class="text-white fw-bold"> <?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()->wallet->investment_balance)); ?></span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(getArrayValue($setting->investment_setting, getInputName(\App\Enums\InvestmentType::TRADE_PREDICTION->name)) == \App\Enums\Status::ACTIVE->value): ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="i-card-sm style-2 bg--dark shadow-none rounded-2">
                            <span class="text--light"><?php echo e(__('Trade Balance')); ?></span> <span class="text-white fw-bold"><?php echo e(getCurrencySymbol()); ?><?php echo e(shortAmount(Auth::user()->wallet->trade_balance)); ?></span>
                        </div>
                    </div>
                <?php endif; ?>


                <?php
                    $investmentIsActive= false;
                    $stakingInvestmentIsActive = false;
                    $tradeIsActive = false;
                    if(getArrayValue($setting->investment_setting, getInputName(\App\Enums\InvestmentType::STAKING_INVESTMENT->name)) == \App\Enums\Status::ACTIVE->value){
                        $investmentIsActive = true;
                    }
                    if(getArrayValue($setting->investment_setting, getInputName(\App\Enums\InvestmentType::INVESTMENT->name)) == \App\Enums\Status::ACTIVE->value){
                        $investmentIsActive = true;
                    }
                    if(getArrayValue($setting->investment_setting, getInputName(\App\Enums\InvestmentType::TRADE_PREDICTION->name)) == \App\Enums\Status::ACTIVE->value){
                        $tradeIsActive = true;
                    }
                ?>
            </div>
        </div>
        <div class="row">
            <?php if($investmentIsActive || $tradeIsActive || $stakingInvestmentIsActive): ?>
                <div class="col-lg-6">
                    <div class="i-card-sm mb-4">
                        <div class="card-header">
                            <h4 class="fs-17 border--left mb-4"><?php echo e(__("Transfer the balance from your trade and investment account to your primary account, and subsequently initiate a withdrawal of your balance.")); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row align-items-center gy-4">
                                <div class="user-form">
                                    <form method="POST" action="<?php echo e(route('user.wallet.transfer.own-account')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-inner">
                                                    <label for="account"><?php echo e(__('Account')); ?></label>
                                                    <select id="account" name="account" required>
                                                        <option value=""><?php echo e(__('Select One')); ?></option>
                                                        <?php if($investmentIsActive || $stakingInvestmentIsActive): ?>
                                                            <option value="<?php echo e(\App\Enums\Transaction\WalletType::INVESTMENT->value); ?>"><?php echo e(\App\Enums\Transaction\WalletType::INVESTMENT->name); ?></option>
                                                        <?php endif; ?>
                                                        <?php if($tradeIsActive): ?>
                                                            <option value="<?php echo e(\App\Enums\Transaction\WalletType::TRADE->value); ?>"><?php echo e(\App\Enums\Transaction\WalletType::TRADE->name); ?></option>
                                                        <?php endif; ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="form-inner">
                                                    <label for="amount"><?php echo e(__('Amount')); ?></label>
                                                    <input type="number" id="amount" name="amount" placeholder="<?php echo e(__('Enter Amount')); ?>" required>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit" class="i-btn btn--primary btn--lg"><?php echo e(__('Save')); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-lg-6">
                <div class="i-card-sm">
                    <div class="card-header">
                        <h4 class="fs-17 border--left mb-4"><?php echo e(__("Transfer the balance from your primary account to other users.")); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="row align-items-center gy-4">
                            <?php if(getArrayValue($setting->system_configuration, 'balance_transfer.value') == \App\Enums\Status::ACTIVE->value): ?>
                                <div class="user-form">
                                    <form method="POST" action="<?php echo e(route('user.wallet.transfer.other-account')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-inner">
                                                    <label for="user"><?php echo e(__('User')); ?> (<?php echo e(__('Check the dashboard for UID if not found.')); ?>)</label>
                                                    <input type="text" id="user" class="find-user" name="uuid" placeholder="Enter User UID" required>
                                                    <span class="user-message text-danger"></span>
                                                    <span class="user-success-message text-success"></span>
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="form-inner">
                                                    <label for="amount"><?php echo e(__('Amount')); ?></label>
                                                    <input type="number" id="amount" name="amount" placeholder="<?php echo e(__('Enter Amount')); ?>" required>
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button type="submit" class="i-btn btn--primary btn--lg"><?php echo e(__('Save')); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            <?php else: ?>
                                <p><?php echo e(__('Balance Transfer Currently Unavailable')); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        $('.find-user').on('focusout', function(e) {
            const url = '<?php echo e(route('user.find.user')); ?>';
            const uuid = $(this).val();
            const token = '<?php echo e(csrf_token()); ?>';

            const data = {
                uuid: uuid,
                _token: token
            };

            $.get(url, data, function(response) {
                if (response.status) {
                    $('.user-message').text(response.message);
                } else {
                    $('.user-success-message').text(response.message);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dakehfsw/app.stellenccecapital.com/src/resources/views/user/wallet-top-up.blade.php ENDPATH**/ ?>